<!doctype html>
<html lang="cs">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.bundle.min.js" integrity="sha384-FKyoEForCGlyvwx9Hj09JcYn3nv7wiPVlz7YYwJrWVcXK/BmnVDxM+D2scQbITxI" crossorigin="anonymous"></script>
  <link rel="stylesheet" href="/css/styles.css">
  <title>Ukázková aplikace</title>
</head>

<?php
  $currentUrl = $_SERVER['REQUEST_URI'];
  function getQueryParams($url) {
      $parsedUrl = parse_url($url);
      $params = [];
      if (isset($parsedUrl['query'])) {
          parse_str($parsedUrl['query'], $params);
      }
      return $params;
  }
  function isActive($controller, $currentUrl) {
      $params = getQueryParams($currentUrl);
      return (isset($params['controller']) && $params['controller'] == $controller) ? 'active aria-current="page"' : '';
  }
?>

<body>
  <header style="margin-bottom:16px;">
    <nav class="navbar navbar-expand-lg bg-success navbar-dark">
      <div class="container-fluid">
        <a class="navbar-brand" href="#">MVC projekt</a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav me-auto mb-2 mb-lg-0">
            <li class="nav-item">
              <a class="nav-link <?php echo isActive('home', $currentUrl); ?>" href="?controller=home&action=index">Domů</a>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">Produkty</a>
              <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="?controller=product&action=index">Všechno</a></li>
                <li><a class="dropdown-item" href="?controller=product&action=ovoce">Ovoce</a></li>
                <li><a class="dropdown-item" href="?controller=product&action=zelenina">Zelenina</a></li>
                <li><a class="dropdown-item" href="?controller=product&action=orechy">Ořechy</a></li>
              </ul>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo isActive('supplier', $currentUrl); ?>" href="?controller=supplier&action=index">Dodavatelé</a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?php echo isActive('customer', $currentUrl); ?>" href="?controller=customer&action=index">Zákazníci</a>
            </li>
          </ul>
        </div>
      </div>
    </nav>
  </header>
  <div class="container">  
    <main>
        <?php
        if (isset($file) && file_exists($file)) {
            include $file;
        } else {
            echo '<p>Šablona nebyla nalezena.</p>';
        }
        ?>
    </main>

    <footer style="margin-top:18px;color:#666;font-size:0.9em;" class="text-center">
      <p>Ukázka MVC principu.</p>
    </footer>
  </div>
</body>
</html>